<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
?>

<style>
  .selec_chk_c {
    position: absolute;
    width: 1px;
    height: 1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    border: 0;
  }

  .selec_chk_c + label {
    display: inline-block;
    position: relative;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
  }

  .selec_chk_c + label > span {
    display: inline-block;
    position: relative;
    width: 20px;
    height: 20px;
    border: 1px solid #d0d0d0;
    border-radius: 3px;
    background-color: #fff;
    box-sizing: border-box;
    transition: all 0.2s ease-in-out;
  }

  .selec_chk_c:checked + label > span:before {
    content: '✓';
    display: block;
    position: absolute;
    bottom: 1px;
    left: 50%;
    width: 100%;
    height: 100%;
    text-align: center;
    color: #0b81ff;
    transform: translate(-50%, -50%);
    font-size:20px;
  }
  
  
    .selec_chk_ac {
    position: absolute;
    width: 1px;
    height: 1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    border: 0;
  }

  .selec_chk_ac + label {
    display: inline-block;
    position: relative;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
  }

  .selec_chk_ac + label > span {
    display: inline-block;
    position: relative;
    width: 20px;
    height: 20px;
    border: 1px solid #d0d0d0;
    border-radius: 3px;
    background-color: #fff;
    box-sizing: border-box;
    transition: all 0.2s ease-in-out;
  }

  .selec_chk_ac:checked + label > span:before {
    content: '✓';
    display: block;
    position: absolute;
    top: -40%;
    left: 50%;
    width: 100%;
    height: 100%;
    text-align: center;
    color: #0b81ff;
    transform: translate(-50%, -50%);
    font-size:20px;
  }

.fregister {
  justify-content: center;
  align-items: center;
  background-color: #fff;
  z-index: 999999999999;
  width: 100%;
  height: 100%; /* 높이를 100%로 설정하여 화면 전체를 덮도록 함 */
  position: fixed; /* 고정 위치 */
  top: 0; /* 상단에 위치 */
  left: 0; /* 좌측에 위치 */
  padding: 20px;
  box-sizing: border-box; /* 패딩 포함 */
  padding-top:17.5%
}

.register_content {
  margin-top:25px !important;
  max-width:550px;
  margin:auto;
}

.register-button {
  margin-top: 30px;
  min-width: 250px;
  width: 95%;
  max-width: 600px;
  height: 45px;
  font-weight: bold;
  font-size: 1.25em;
  background-color: #2a2a2a;
  position: fixed;
  bottom:5%;
  left: 50%;
  transform: translateX(-50%);
  margin:10px 0;
  border-radius:5px
}

input:focus {outline:none;}
.register_head {
  margin:auto;
  max-width:550px;
}

</style>

<!-- 회원가입약관 동의 시작 { -->
<div class="register" style="display: flex;justify-content: center;align-items: center;">
<form name="fregister" id="fregister" class="fregister" action="<?php echo $register_action_url ?>" onsubmit="return fregister_submit(this);" method="POST" autocomplete="off">

<div class="register_head">
<h1 style="color:#3a3a3a; font-size:2.3em; font-weight:520;padding-bottom:10px">서비스 가입</h1>
<span style="color:#4a4a4a;">회원 프로필 생성 및 관리를 위해 이용약관에 동의해주세요.</span>
</div>

<div class="register_content">
  <!-- 회원가입 약관 동의 -->
   <section id="fregister_term" style="border:none;padding-top:5px">
  <a href="#" class="view-terms"><span style="color:#2a2a2a">(필수) 회원가입 약관 동의</span></a>
  <fieldset class="fregister_agree">
    <input type="checkbox" name="agree" value="1" id="agree11" class="selec_chk_c">
  <label for="agree11"><span style="top:-10px;"></span><b class="sound_only" >회원가입약관의 내용에 동의합니다.</b></label>
    </fieldset>  
    <div class="modal" id="termsModal">
    <div class="modal-content">
        <span class="close-button">&times;</span>
        <textarea readonly style="min-height:300px;height:80%;max-height:520px;width:100%;border-radius:5px;background-color: #f9f9f9;padding:15px;border:none"><?php echo get_text($config['cf_stipulation']) ?></textarea>
    </div>
</div>
     </section>
  <div class="terms-container" style="margin-bottom:10px">
    <div class="terms-item">
      <a href="#" class="view-terms" style="color:#3a86ff;text-decoration-line: underline;">보기</a>
    </div>
  </div>

  <!-- 개인정보 수집 및 이용 동의 -->
  <section id="fregister_private" style="border:none;top:5px">
   <a href="#" class="view-privacy"><span style="color:#2a2a2a">(필수) 개인정보 수집 및 이용 동의</span></a>
  <fieldset class="fregister_agree">
    <input type="checkbox" name="agree2" value="1" id="agree21" class="selec_chk_c">
  <label for="agree21"><span style="top:-10px;"></span><b class="sound_only">개인정보 수집 및 이용의 내용에 동의합니다.</b></label>
   </fieldset>
   <div class="modal" id="privacyModal" style="background-color: rgba(0, 0, 0, 0.15);">
    <div class="modal-content" style="max-height:450px">
        <span class="close-button">&times;</span>
        <div class="privacy-policy">
            <h2>개인정보 수집 및 이용</h2>
            <div class="policy-item">
                <h3>이용자 식별 및 본인 확인</h3>
                <ul>
                    <li>수집항목:</br>아이디, 이름, 비밀번호, cookie<?php echo ($config['cf_cert_use'])? ", 생년월일, 휴대폰 번호(본인인증 할 때만, 아이핀 제외), 암호화된 개인식별부호(CI)" : ""; ?></li>
                    <li>보유기간: </br>회원 탈퇴 시까지</li>
                </ul>
            </div>
            <div class="policy-item">
                <h3>서비스 이용에 관한 통지, 이용자 식별</h3>
                <ul>
                    <li>수집항목:</br>연락처 (이메일)</li>
                    <li>보유기간:</br>회원 탈퇴 시까지</li>
                </ul>
            </div>
        </div>
    </div>
</div>
    </section>
  <div class="privacy-container">
    <div class="privacy-item">
      <a href="#" class="view-privacy" style="color:#3a86ff;text-decoration-line: underline;">보기</a>
    </div>
  </div>
    <section id="fregister" style="border:none;padding-top:15px;border-top:1px solid #f1f1f1">
  <fieldset class="fregister_agree">
    <input type="checkbox" name="chk_all" id="chk_all" class="selec_chk_c">
        <label for="chk_all"><span style="top:10px;"></span></label>
                  </fieldset>
        <span style="color:#3a3a3a;font-weight:520;font-size:1.2em;border:none">전체 동의</span>
        </section>
  <button type="submit" class="register-button" style="color:#f9f9f9;border:none">다음</button>
</div>
</form>


<script>
    // 회원가입 약관 보기 버튼 클릭 이벤트
    document.querySelectorAll('.view-terms').forEach(function(button) {
        button.addEventListener('click', function() {
            document.getElementById('termsModal').style.display = 'block';
        });
    });

    // 개인정보 수집 및 이용 보기 버튼 클릭 이벤트
    document.querySelectorAll('.view-privacy').forEach(function(button) {
        button.addEventListener('click', function() {
            document.getElementById('privacyModal').style.display = 'block';
        });
    });

    // 모달 닫기 버튼 클릭 이벤트
    document.querySelectorAll('.close-button').forEach(function(button) {
        button.addEventListener('click', function() {
            document.querySelectorAll('.modal').forEach(function(modal) {
                modal.style.display = 'none';
            });
        });
    });

    // 모달 외부 클릭 시 닫기
    window.addEventListener('click', function(event) {
        document.querySelectorAll('.modal').forEach(function(modal) {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        });
    });
</script>

<style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.4);
    }

    .modal-content {
        background-color: #fefefe;
        margin: 15% auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
        height:80%;
    }

    .close-button {
        color: #aaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    .close-button:hover,
    .close-button:focus {
        color: black;
        text-decoration: none;
        cursor: pointer;
    }

.privacy-policy {
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  padding: 20px;
  border-radius: 10px;
}

.privacy-policy h2 {
  font-size: 24px;
  font-weight: 600;
  margin-bottom: 20px;
  color: #333;
}

.policy-item {

}

.policy-item h3 {
  font-size: 15px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #333;
}

.policy-item ul {
  list-style-type: none;
  padding: 0;
}

.policy-item li {
  font-size: 12px;
  color: #666;
  margin-bottom: 5px;
}

    .terms-item label, .privacy-item label {
        margin-right: 10px;
    }

    .terms-item a, .privacy-item a {
        margin-left: auto;
    }
</style>

    </form>
    <script>
    function fregister_submit(f)
    {
        if (!f.agree.checked) {
            alert("회원가입약관의 내용에 동의하셔야 회원가입 하실 수 있습니다.");
            f.agree.focus();
            return false;
        }

        if (!f.agree2.checked) {
            alert("개인정보 수집 및 이용의 내용에 동의하셔야 회원가입 하실 수 있습니다.");
            f.agree2.focus();
            return false;
        }

        return true;
    }
    
    jQuery(function($){
        // 모두선택
        $("input[name=chk_all]").click(function() {
            if ($(this).prop('checked')) {
                $("input[name^=agree]").prop('checked', true);
            } else {
                $("input[name^=agree]").prop("checked", false);
            }
        });
    });

    </script>
</div>
<!-- } 회원가입 약관 동의 끝 -->

<script>
// 체크박스 요소 선택
const chkAll = document.getElementById('chk_all');
const registerButton = document.querySelector('.register-button');

// 체크박스 상태 변화 이벤트 리스너 등록
chkAll.addEventListener('change', function() {
  if (this.checked) {
    registerButton.style.backgroundColor = '#0b81ff';
    registerButton.style.transition = 'background-color 0.3s ease'; // 부드러운 전환을 위한 트랜지션 설정
  } else {
    registerButton.style.backgroundColor = ''; // 기본 스타일로 변경
    registerButton.style.transition = 'background-color 0.3s ease'; // 부드러운 전환을 위한 트랜지션 설정
  }
});
</script>
<script>
// 회원가입 약관 동의 체크박스
const agreeCheckbox = document.getElementById('agree11');
// 개인정보 수집 및 이용 동의 체크박스
const privacyCheckbox = document.getElementById('agree21');
// 전체 동의 체크박스
const allAgreeCheckbox = document.getElementById('chk_all');

// 두 개의 체크박스 상태를 감시하고 전체 동의 체크박스를 업데이트하는 함수
function updateAllAgreeCheckbox() {
  if (agreeCheckbox.checked && privacyCheckbox.checked) {
    allAgreeCheckbox.checked = true;
  } else {
    allAgreeCheckbox.checked = false;
  }
}

// 체크박스 상태 변화 이벤트 리스너 등록
agreeCheckbox.addEventListener('change', updateAllAgreeCheckbox);
privacyCheckbox.addEventListener('change', updateAllAgreeCheckbox);
</script>
<script>
window.onload = function() {
  // 체크박스와 버튼 요소 선택
  const agree1 = document.getElementById('agree11');
  const agree2 = document.getElementById('agree21');
  const registerButton = document.querySelector('.register-button');

  // 체크박스 상태 변화 감지
  agree1.addEventListener('change', checkAgreement);
  agree2.addEventListener('change', checkAgreement);

  // 체크박스 상태 확인 및 버튼 색상 변경 함수
  function checkAgreement() {
    if (agree1.checked && agree2.checked) {
      registerButton.style.backgroundColor = '#0b81ff';
      registerButton.style.transition = 'background-color 0.3s ease';
    } else {
      registerButton.style.backgroundColor = '';
      registerButton.style.transition = 'background-color 0.3s ease';
    }
  }
};
</script>